/*
* JBoss, Home of Professional Open Source
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.cache.test.local;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.transaction.DummyTransactionManager;

import javax.transaction.Transaction;

/**
 * @author Bela Ban
 * @version $Id:AcquireAllTestCase.java,v 1.0, 2005-06-24 18:43:46Z, Robert Worsnop$
 */
public class AcquireAllTestCase extends TestCase {
   TreeCache cache=null, cache2;
   Transaction tx=null;
   final Fqn FQN=Fqn.fromString("/myNode");
   final String KEY="key";
   final String VALUE="value";





   protected void setUp() throws Exception {
      super.setUp();
   }

   protected void tearDown() throws Exception {
      super.tearDown();
      if(cache != null) {
         cache.stopService();
         cache.destroyService();
         cache=null;
      }
      if(tx != null) {
         tx.commit();
         tx=null;
      }
   }


   public void testAcquireAll() throws Exception {
      Node root;
      Object owner=Thread.currentThread();

      cache=createCache(TreeCache.LOCAL, IsolationLevel.SERIALIZABLE);
      cache.put("/a/b/c", null);
      cache.put("/1/2/3", null);

      root=cache.getRoot();


      root.acquireAll(owner, 2000, Node.LOCK_TYPE_READ);
      root.releaseAll(owner);

      assertEquals(0, cache.getNumberOfLocksHeld());

      root.acquireAll(owner, 2000, Node.LOCK_TYPE_WRITE);
      root.releaseAll(owner);

      assertEquals(0, cache.getNumberOfLocksHeld());
   }


   public void testAcquireAllReplicated() throws Exception {
      Node root;
      Object owner=Thread.currentThread();

      cache2=createCache(TreeCache.REPL_ASYNC, IsolationLevel.SERIALIZABLE);
      cache2.put("/a/b/c", null);
      cache2.put("/1/2/3", null);

      cache=createCache(TreeCache.REPL_ASYNC, IsolationLevel.SERIALIZABLE);
      root=cache.getRoot();

      root.acquireAll(owner, 2000, Node.LOCK_TYPE_READ);
      root.releaseAll(owner);

      assertEquals(0, cache.getNumberOfLocksHeld());

      root.acquireAll(owner, 2000, Node.LOCK_TYPE_WRITE);
      root.releaseAll(owner);

      assertEquals(0, cache.getNumberOfLocksHeld());
   }



   TreeCache createCache(int mode, IsolationLevel level) throws Exception {
      TreeCache c=new TreeCache();
      c.setCacheMode(mode);
      c.setIsolationLevel(level);
      c.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
      c.createService();
      c.startService();
      return c;
   }

   Transaction startTransaction() {
      DummyTransactionManager mgr=DummyTransactionManager.getInstance();
      try {
         mgr.begin();
         return mgr.getTransaction();
      }
      catch(Throwable t) {
         return null;
      }
   }




   public static Test suite() {
      return new TestSuite(AcquireAllTestCase.class);
   }

   public static void main(String[] args) {
      junit.textui.TestRunner.run(suite());
   }

}
