/*
 *
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.aop.test;

import javax.management.ObjectName;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.log4j.Category;

import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.test.JBossTestCase;
import org.jboss.test.aop.bean.NonadvisedPOJO;
import org.jboss.test.aop.bean.POJO;
import org.jboss.aop.proxy.ClassProxy;

/**
* Sample client for the jboss container.
*
* @author <a href="mailto:bill@burkecentral.com">Bill Burke</a>
* @version $Id:RemotingUnitTestCase.java,v 1.0, 2005-06-24 19:14:59Z, Robert Worsnop$
*/

public class RemotingUnitTestCase
   extends JBossTestCase
{
   Category log = getLog();

   private ObjectName testerName = ObjectNameFactory.create("jboss.aop:name=RemotingTester");

   private Object[] noparams = {};
   private String[] nosig = {};

   public RemotingUnitTestCase(String name)
   {
      super(name);
   }

   protected void setUp() throws Exception
   {
      //load the network registry
   }

   protected void tearDown() throws Exception
   {
   }

   public void testRemoting() throws Exception
   {
      RMIAdaptor server = getServer();
      POJO pojo = (POJO)server.invoke(testerName, "testRemoting", noparams, nosig);
      ClassProxy proxy = (ClassProxy)pojo;
      String rtn = pojo.remoteTest(); // invokes remotely
      if (!rtn.equals("hello"))
         throw new Exception("DID NOT GET EXPECTED REMOTE VALUE");
   }

   public void testNonadvisedRemoting() throws Exception
   {
      RMIAdaptor server = getServer();
      NonadvisedPOJO pojo = (NonadvisedPOJO)server.invoke(testerName, "testNonadvisedRemoting", noparams, nosig);
      String rtn = pojo.remoteTest(); // invokes remotely
      if (!rtn.equals("hello"))
         throw new Exception("DID NOT GET EXPECTED REMOTE VALUE");
   }

   public void testClusteredRemoting() throws Exception
   {
      RMIAdaptor server = getServer();
      POJO pojo = (POJO)server.invoke(testerName, "testClusteredRemoting", noparams, nosig);
      try
      {
         String rtn = pojo.remoteTest(); // invokes remotely
         if (!rtn.equals("hello"))
            throw new Exception("DID NOT GET EXPECTED REMOTE VALUE");
         pojo.remoteTest();//just make sure we can invoke twice...
      }
      finally
      {
         unregisterTarget(server, pojo);
      }
   }

   public void testClusteredNonadvisedRemoting() throws Exception
   {
      RMIAdaptor server = getServer();
      NonadvisedPOJO pojo = (NonadvisedPOJO)server.invoke(testerName, "testClusteredNonadvisedRemoting", noparams, nosig);
      try
      {
         String rtn = pojo.remoteTest(); // invokes remotely
         if (!rtn.equals("hello"))
            throw new Exception("DID NOT GET EXPECTED REMOTE VALUE");
      }
      finally
      {
         unregisterTarget(server, pojo);
      }
   }

   public static Test suite() throws Exception
   {
      TestSuite suite = new TestSuite();
      suite.addTest(new TestSuite(AOPUnitTestCase.class));

      AOPTestSetup setup = new AOPTestSetup(suite, "aoptest.sar");
      return setup; 
   }

   protected void unregisterTarget(RMIAdaptor server, Object proxy)
      throws Exception
   {
      Object[] params = { proxy };
      String[] sig = { "java.lang.Object" };
      server.invoke(testerName, "unregisterTarget", params, sig);
   }

}
