/*
 *
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.aop.test;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.test.JBossTestCase;
import org.jboss.test.JBossTestServices;

import javax.management.ObjectName;
import javax.management.Attribute;
import javax.naming.InitialContext;

/**
 * Sample client for the jboss container.
 *
 * @author <a href="mailto:bill@burkecentral.com">Bill Burke</a>
 * @version $Id:AOPUnitTestCase.java,v 1.0, 2005-06-24 18:45:19Z, Robert Worsnop$
 */

public class AOPUnitTestCase
        extends JBossTestCase
{
   org.apache.log4j.Category log = getLog();

   static boolean deployed = false;
   static int test = 0;

   public AOPUnitTestCase(String name)
   {

      super(name);

   }

   public void testAspect() throws Exception
   {
      RMIAdaptor server = getServer();
      ObjectName testerName = new ObjectName("jboss.aop:name=AOPTester");
      Object[] params = {};
      String[] sig = {};
      server.invoke(testerName, "testAspect", params, sig);
   }

   public void testBasic() throws Exception
   {
      RMIAdaptor server = getServer();
      ObjectName testerName = new ObjectName("jboss.aop:name=AOPTester");
      Object[] params = {};
      String[] sig = {};
      server.invoke(testerName, "testBasic", params, sig);
   }

   public void testCallerPointcut() throws Exception
   {
      RMIAdaptor server = getServer();
      ObjectName testerName = new ObjectName("jboss.aop:name=AOPTester");
      Object[] params = {};
      String[] sig = {};
      server.invoke(testerName, "testCallerPointcut", params, sig);
   }

   public void testInheritance() throws Exception
   {
      RMIAdaptor server = getServer();
      ObjectName testerName = new ObjectName("jboss.aop:name=AOPTester");
      Object[] params = {};
      String[] sig = {};
      server.invoke(testerName, "testInheritance", params, sig);
   }

   public void testMetadata() throws Exception
   {
      RMIAdaptor server = getServer();
      ObjectName testerName = new ObjectName("jboss.aop:name=AOPTester");
      Object[] params = {};
      String[] sig = {};
      server.invoke(testerName, "testMetadata", params, sig);
   }

   public void testDynamicInterceptors() throws Exception
   {
      RMIAdaptor server = getServer();
      ObjectName testerName = new ObjectName("jboss.aop:name=AOPTester");
      Object[] params = {};
      String[] sig = {};
      server.invoke(testerName, "testDynamicInterceptors", params, sig);
   }

   public void testFieldInterception() throws Exception
   {
      RMIAdaptor server = getServer();
      ObjectName testerName = new ObjectName("jboss.aop:name=AOPTester");
      Object[] params = {};
      String[] sig = {};
      server.invoke(testerName, "testFieldInterception", params, sig);
   }

   public void testMixin() throws Exception
   {
      RMIAdaptor server = getServer();
      ObjectName testerName = new ObjectName("jboss.aop:name=AOPTester");
      Object[] params = {};
      String[] sig = {};
      server.invoke(testerName, "testMixin", params, sig);
   }


   public void testMethodInterception() throws Exception
   {
      RMIAdaptor server = getServer();
      ObjectName testerName = new ObjectName("jboss.aop:name=AOPTester");
      Object[] params = {};
      String[] sig = {};
      server.invoke(testerName, "testMethodInterception", params, sig);
   }

   public void testConstructorInterception() throws Exception
   {
      RMIAdaptor server = getServer();
      ObjectName testerName = new ObjectName("jboss.aop:name=AOPTester");
      Object[] params = {};
      String[] sig = {};
      server.invoke(testerName, "testConstructorInterception", params, sig);
   }

   public void testExceptions() throws Exception
   {
      RMIAdaptor server = getServer();
      ObjectName testerName = new ObjectName("jboss.aop:name=AOPTester");
      Object[] params = {};
      String[] sig = {};
      server.invoke(testerName, "testExceptions", params, sig);
   }

   public static Test suite() throws Exception
   {
      TestSuite suite = new TestSuite();
      suite.addTest(new TestSuite(AOPUnitTestCase.class));

      AOPTestSetup setup = new AOPTestSetup(suite, "aoptest.sar");
      return setup; 
   }

}
