/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.aop.bean;

import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;

/**
 * @author ifedorenko
 */
public class SimpleBeanInterceptorFactory implements org.jboss.aop.advice.AspectFactory
{
   public Object createPerVM()
   {
      return new SimpleBeanInterceptor();
   }

   public Object createPerClass(Advisor advisor)
   {
      return new SimpleBeanInterceptor();
   }

   public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor)
   {
      return new SimpleBeanInterceptor();
   }

   public Object createPerJoinpoint(Advisor advisor, Joinpoint jp)
   {
      return new SimpleBeanInterceptor();
   }

   public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp)
   {
      return new SimpleBeanInterceptor();
   }

   public String getName()
   {
      return getClass().getName();
   }
}
