/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.aop.bean;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;
import org.jboss.logging.Logger;

import java.lang.reflect.Method;

/**
 * @author ifedorenko
 */
public class SimpleBeanCallerInterceptor implements Interceptor
{

   static Logger log = Logger.getLogger(SimpleBeanCallerInterceptor.class);
   public static boolean wasCalled = false;
   public String getName()
   {
      return "SimpleBeanCallerInterceptor";
   }

   public Object invoke(Invocation invocation) throws Throwable
   {
      wasCalled = true;
      return invocation.invokeNext();
   }
}
