/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.aop.bean;

import org.jboss.aop.Dispatcher;
import org.jboss.aop.Advised;
import org.jboss.aspects.remoting.ClusteredRemoting;
import org.jboss.aspects.remoting.Remoting;
import org.jboss.ha.framework.interfaces.RoundRobin;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.system.ServiceMBeanSupport;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
/**
 *
 * @see Monitorable
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision:1$
 */
public class RemotingTester
   extends ServiceMBeanSupport
   implements RemotingTesterMBean, MBeanRegistration
{
   // Constants ----------------------------------------------------
   // Attributes ---------------------------------------------------
   static Logger log = Logger.getLogger(RemotingTester.class);
   MBeanServer m_mbeanServer;

   // Static -------------------------------------------------------

   // Constructors -------------------------------------------------
   public RemotingTester()
   {}

   // Public -------------------------------------------------------

   // MBeanRegistration implementation -----------------------------------
   public ObjectName preRegister(MBeanServer server, ObjectName name)
   throws Exception
   {
      m_mbeanServer = server;
      return name;
   }

   public void postRegister(Boolean registrationDone)
   {}
   public void preDeregister() throws Exception
   {}
   public void postDeregister()
   {}

   protected void startService()
      throws Exception
   {
   }

   protected void stopService()
   {
   }

   public POJO testRemoting()
   {
      try
      {
         log.info("Testing REMOTING");
         POJO remote = new POJO("hello");
         Dispatcher.singleton.registerTarget("myobj", remote);

         return (POJO)Remoting.createRemoteProxy("myobj", remote.getClass(), "socket://localhost:5150");
      }
      catch (Throwable ex)
      {
         log.error("failed", ex);
         throw new RuntimeException(ex.getMessage());
      }
   }

   public NonadvisedPOJO testNonadvisedRemoting()
   {
      try
      {
         log.info("Testing NONADVISED REMOTING");
         NonadvisedPOJO remote = new NonadvisedPOJO("hello");
         Dispatcher.singleton.registerTarget("myobj", remote);

         return (NonadvisedPOJO)Remoting.createRemoteProxy("myobj", remote.getClass(), "socket://localhost:5150");
      }
      catch (Throwable ex)
      {
         log.error("failed", ex);
         throw new RuntimeException(ex.getMessage());
      }
   }

   public POJO testClusteredRemoting()
   {
      try
      {
         log.info("Testing CLUSTERED REMOTING");
         POJO remote = new POJO("hello");
         return (POJO)ClusteredRemoting.clusterObject("clusteredobj", remote,
                                                                "DefaultPartition", new RoundRobin(),
                                                                new InvokerLocator("socket://localhost:5150"));
      }
      catch (Throwable ex)
      {
         log.error("failed", ex);
         throw new RuntimeException(ex.getMessage());
      }
   }
   public NonadvisedPOJO testClusteredNonadvisedRemoting()
   {
      try
      {
         log.info("Testing CLUSTERED NONADVISED REMOTING");
         NonadvisedPOJO remote = new NonadvisedPOJO("hello");
         return (NonadvisedPOJO)ClusteredRemoting.clusterObject("nonadvisedclusteredobj", remote,
                                                                          "DefaultPartition", new RoundRobin(),
                                                                          new InvokerLocator("socket://localhost:5150"));
      }
      catch (Throwable ex)
      {
         log.error("failed", ex);
         throw new RuntimeException(ex.getMessage());
      }
   }

   public void unregisterTarget(Object object)
   {
      ClusteredRemoting.unregisterClusteredObject(object);
   }

   // Inner classes -------------------------------------------------
}

