/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.aop.bean;

import org.jboss.aspects.patterns.observable.Observer;
import org.jboss.aspects.patterns.observable.Subject;

/**
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class LogUtilObserver implements Observer
{
   private LogUtil logUtil;
   
   public LogUtilObserver(LogUtil logUtil)
   {
      this.logUtil = logUtil;
   }
   
   public void fireChange(Subject subject)
   {
      logUtil.log(subject.toString());
   }
}

