/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.aop.bean;

import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.logging.Logger;

/**
 * @author ifedorenko
 */
public class CallerInterceptor implements org.jboss.aop.advice.Interceptor
{

   static Logger log = Logger.getLogger(CallerInterceptor.class);
   public static final String RETURN_VALUE = "aspect";
   public String getName()
   {
      return "CallerInterceptor";
   }
   public static boolean called = false;
   public Object invoke(org.jboss.aop.joinpoint.Invocation invocation) throws Throwable
   {
      log.info("in CallerInterceptor: " + invocation);
      called = true;
      return invocation.invokeNext();
   }
}
