/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test;

import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * Derived implementation of JBossTestCase for cluster testing.
 *
 * @author <a href="mailto:sacha.labourey@cogito-info.ch">Sacha Labourey</a>.
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 * @see org.jboss.test.JBossTestCase
 */
public class JBossClusteredTestCase extends JBossTestCase
{
   JBossTestClusteredServices clusterServices;

   public JBossClusteredTestCase(String name)
   {
      super(name);
   }

   public void initDelegate()
   {
      clusterServices = new JBossTestClusteredServices(getClass().getName());
      delegate = clusterServices;
   }
   
   // Public --------------------------------------------------------
   
   public void testServerFound() throws Exception
   {
      if (deploymentException != null)
         throw deploymentException;
      assertTrue("Server was not found", getServers() != null);
   }


   public RMIAdaptor[] getAdaptors() throws Exception
   {
      return clusterServices.getAdaptors();
   }

   public String[] getServers() throws Exception
   {
      return clusterServices.getServers();
   }

   public String[] getNamingURLs() throws Exception
   {
      return clusterServices.getNamingURLs();
   }
   public String[] getHttpURLs() throws Exception
   {
      return clusterServices.getHttpURLs();
   }

   public static Test getDeploySetup(final Test test, final String jarName)
      throws Exception
   {
      JBossTestSetup wrapper = new JBossTestClusteredSetup(test)
      {

         protected void setUp() throws Exception
         {
            if (jarName == null) return;
            deploymentException = null;
            try
            {
               this.deploy(jarName);
               this.getLog().debug("deployed package: " + jarName);
            }
            catch (Exception ex)
            {
               // Throw this in testServerFound() instead.
               deploymentException = ex;
            }
                
            // wait a few seconds so that the cluster stabilize
            synchronized (this)
            {
               wait(2000);
            }
         }

         protected void tearDown() throws Exception
         {
            if (jarName == null) return;
            this.getLog().debug("Attempt undeploy of " + jarName);
            this.undeploy(jarName);
            this.getLog().debug("undeployed package: " + jarName);
         }
      };
      return wrapper;
   }

   public static Test getDeploySetup(final Class clazz, final String jarName)
      throws Exception
   {
      TestSuite suite = new TestSuite();
      suite.addTest(new TestSuite(clazz));
      return getDeploySetup(suite, jarName);
   }

   /**
    * anil
    */
   public void setServerNames(String[] snames) throws Exception
   {
      ((JBossTestClusteredServices) delegate).setServerNames(snames);
   }

   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------

}
