/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.system.pm;

import javax.management.AttributeList;
import org.jboss.mx.persistence.AttributePersistenceManager;
import org.w3c.dom.Element;
/**
 * NullAttributePersistenceManager.
 * 
 * @author  <a href="mailto:dimitris@jboss.org">Dimitris Andreadis</a>
 * @version $Revision:1$
 */
public class NullAttributePersistenceManager
   implements  AttributePersistenceManager
{
   private boolean isCreated = false;
   
   public void create(String version, Element config)
      throws Exception
   {
      isCreated = true;
   }

   public boolean getState()
   {
      return isCreated;
   }
   
   public void destroy()
   {
      isCreated = false;
   }
   
   // AttributePersistenceManager Persistence -----------------------
   
   public boolean exists(String id)
      throws Exception
   {
      return false;
   }

   public AttributeList load(String id)
      throws Exception
   {
      return null;
   }
   
   public void store(String id, AttributeList attrs)
      throws Exception
   {
      // empty
   }
   
   public void remove(String id)
      throws Exception
   {
      // empty
   }
   
   public void removeAll()
      throws Exception
   {
      // empty
   }
   
   public String[] listAll()
      throws Exception
   {
      return new String[0];
   }   
}
