/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.system;

import javax.management.NotificationFilter;

import org.w3c.dom.Element;

/**
 * Abstracts NotificationFilter creation based on an arbritrary
 * xml element fragment. Used by ListenerServiceMBeanSupport
 * to enable NotificationFilterFactory plugins.
 * 
 * @see ListenerServiceMBeanSupport
 *
 * @author <a href="mailto:dimitris@jboss.org">Dimitris Andreadis</a>
 * @version $Revision:1$
**/
public interface NotificationFilterFactory
{
   /**
    * Create a notification filter implementation and initialize
    * it, using the passed xml element fragment.
    * 
    * @param filterConfig the xml fragment to use for configuring the filter
    * @return an initialized NotificationFilter
    * @throws Exception in case the xml fragment cannot be parsed properly
    */
   public NotificationFilter createNotificationFilter(Element filterConfig)
      throws Exception;
}
