/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.deployment;

// $Id:SerializableDeploymentInfo.java,v 1.0, 2005-06-24 19:15:45Z, Robert Worsnop$

import javax.management.ObjectName;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * DeploymentInfo for remote access by the DeploymentManager.
 * It provides a serializable subset of the information available in DeploymentInfo.
 *
 * @author thomas.diesler@jboss.org
 * @version $Revision:1$
 */
public class SerializableDeploymentInfo implements Serializable
{
   /** @since 4.0.2 */
   private static final long serialVersionUID = -3847995513551913798L;
   
   // The initial construction timestamp
   public Date date;
   // The URL identifing this SDI
   public URL url;
   // An optional URL to a local copy of the deployment
   public URL localUrl;
   // The URL used to watch for changes when the deployment is unpacked
   public URL watch;
   // The suffix of the deployment url
   public String shortName;
   // The last system time the deployment inited by the MainDeployer
   public long lastDeployed;
   // Use for "should we redeploy failed"
   public long lastModified;
   // A free form status for the "state" can be Deployed/failed etc etc
   public String status;
   // The current state of the deployment
   public DeploymentState state;
   // The subdeployer that handles the deployment
   public ObjectName deployer;
   // The classpath declared by this xml descriptor, needs <classpath> entry
   public Collection classpath = new ArrayList();
   // The mbeans deployed
   public List mbeans;
   // Anyone can have subdeployments
   public List subDeployments;
   // And the subDeployments have a parent
   public SerializableDeploymentInfo parent;
   // the web root context in case of war file
   public String webContext;
   // An optional URL to the URL of the document loaded
   public URL documentUrl;
   // Is this a stand-alone service descriptor
   public boolean isXML;
   public boolean isScript;
   // Does the deployment url point to a directory
   public boolean isDirectory;
   // Can contain the MBean that is created through the deployment
   public ObjectName deployedObject;

   // Constructors *****************************************************************************************************

   /**
    * Construct this object from a DeploymentInfo
    */
   public SerializableDeploymentInfo(DeploymentInfo info)
   {
      this.date = info.date;
      this.url = info.url;
      this.localUrl = info.localUrl;
      this.watch = info.watch;
      this.shortName = info.shortName;
      this.lastDeployed = info.lastDeployed;
      this.lastModified = info.lastModified;
      this.status = info.status;
      this.state = info.state;
      this.deployer = info.deployer.getServiceName();
      this.classpath = info.classpath;
      this.mbeans = info.mbeans;
      this.webContext = info.webContext;
      this.documentUrl = info.documentUrl;
      this.isXML = info.isXML;
      this.isScript = info.isScript;
      this.isDirectory = info.isDirectory;
      this.deployedObject = info.deployedObject;

      // we do these in a second iteration
      this.parent = null;
      this.subDeployments = new ArrayList();
   }

   /**
    * Returns a string representation of the object.
    */
   public String toString()
   {
      StringBuffer s = new StringBuffer(super.toString());
      s.append(" { url=" + url + " }\n");
      s.append("  deployer: " + deployer + "\n");
      s.append("  status: " + status + "\n");
      s.append("  state: " + state + "\n");
      s.append("  watch: " + watch + "\n");
      s.append("  lastDeployed: " + lastDeployed + "\n");
      s.append("  lastModified: " + lastModified + "\n");
      s.append("  mbeans: " + mbeans + "\n");
      s.append(" }\n");
      return s.toString();
   }
}
