/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.security.auth.spi;

import org.jboss.xml.binding.ObjectModelFactory;
import org.jboss.xml.binding.ContentNavigator;
import org.jboss.logging.Logger;
import org.xml.sax.Attributes;

/** A JBossXB object factory for parsing the 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class UsersObjectModelFactory implements ObjectModelFactory
{
   private static Logger log = Logger.getLogger(UsersObjectModelFactory.class);

   public Object newRoot(Object root, ContentNavigator navigator,
      String namespaceURI, String localName, Attributes attrs)
   {
      if (!localName.equals("users"))
      {
         throw new IllegalStateException("Unexpected root element: was expecting 'users' but got '" + localName + "'");
      }
      log.trace("newRoot, root="+root);
      return new Users();
   }

   public void setValue(Users users, ContentNavigator navigator,
      String namespaceUri, String localName, String value)
   {
   }

   public Object newChild(Users users, ContentNavigator navigator,
      String namespaceUri, String localName, Attributes attrs)
   {
      Users.User child = null;
      if("user".equals(localName))
      {
         String name = attrs.getValue("name");
         child = new Users.User(name);
         String password = attrs.getValue("password");
         child.setPassword(password);
         String encoding = attrs.getValue("encoding");
         child.setEncoding(encoding);
         log.trace("newChild, user="+child);
      }
      return child;
   }

   public void addChild(Users users, Users.User user,
      ContentNavigator navigator, String namespaceURI, String localName)
   {
      users.addUser(user);
   }

   public Object newChild(Users.User user, ContentNavigator navigator,
      String namespaceUri, String localName, Attributes attrs)
   {
      String[] roleInfo = {null, "Roles"};
      if("role".equals(localName))
      {
         roleInfo[0] = attrs.getValue("name");
         roleInfo[1] = attrs.getValue("group");
         if( roleInfo[1] == null )
            roleInfo[1] = "Roles";
      }
      return roleInfo;
   }

   public void addChild(Users.User user, String[] roleInfo,
      ContentNavigator navigator, String namespaceURI, String localName)
   {
      user.addRole(roleInfo[0], roleInfo[1]);
   }
}
