/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.security.auth.spi;

import java.util.Iterator;
import java.util.HashMap;
import java.util.ArrayList;
import java.util.Enumeration;
import java.security.acl.Group;
import java.security.Principal;

import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class Users
{
   private HashMap users = new HashMap();

   public static class User implements Comparable
   {
      private String name;
      private String password;
      private String encoding;
      private HashMap roleGroups = new HashMap();

      public User()
      {
      }
      public User(String name)
      {
         this.name = name;
      }
      public String getName()
      {
         return name;
      }
      public String getPassword()
      {
         return password;
      }
      public void setPassword(String password)
      {
         this.password = password;
      }

      public String getEncoding()
      {
         return encoding;
      }
      public void setEncoding(String encoding)
      {
         this.encoding = encoding;
      }

      public Group[] getRoleSets()
      {
         Group[] roleSets = new Group[roleGroups.size()];
         roleGroups.values().toArray(roleSets);
         return roleSets;
      }
      public String[] getRoleNames()
      {
         return getRoleNames("Roles");
      }
      public String[] getRoleNames(String roleGroup)
      {
         Group group = (Group) roleGroups.get(roleGroup);
         String[] names = {};
         if( group != null )
         {
            ArrayList tmp = new ArrayList();
            Enumeration iter = group.members();
            while( iter.hasMoreElements() )
            {
               Principal p = (Principal) iter.nextElement();
               tmp.add(p.getName());
            }
            names = new String[tmp.size()];
            tmp.toArray(names);
         }
         return names;
      }
      public void addRole(String roleName, String roleGroup)
      {
         Group group = (Group) roleGroups.get(roleGroup);
         if( group == null )
         {
            group = new SimpleGroup(roleGroup);
            roleGroups.put(roleGroup, group);
         }
         SimplePrincipal role = new SimplePrincipal(roleName);
         group.addMember(role);
      }
      public int compareTo(Object obj)
      {
         User u = (User) obj;
         return name.compareTo(u.name);
      }

      public String toString()
      {
         return "User{" +
            "name='" + name + "'" +
            ", password=*" + 
            ", encoding='" + encoding + "'" +
            ", roleGroups=" + roleGroups +
            "}";
      }
   }

   public void addUser(User user)
   {
      users.put(user.getName(), user);
   }
   public Iterator getUsers()
   {
      return users.values().iterator();
   }
   public User getUser(String name)
   {
      User find = (User) users.get(name);
      return find;
   }
   
   public String toString()
   {
      return "Users("+System.identityHashCode(this)+"){" +
         "users=" + users +
         "}";
   }
}
