/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.security.auth.login;

import java.util.Collections;
import java.util.Map;
import java.util.HashMap;
import java.util.ArrayList;
import java.util.Set;

/** The root object for the login-config.xml descriptor as defined by the
 * security-config_4_0.xsd.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class PolicyConfig
{
   Map config = Collections.synchronizedMap(new HashMap());

   public void add(AuthenticationInfo authInfo)
   {
      config.put(authInfo.getName(), authInfo);
   }
   public AuthenticationInfo get(String name)
   {
      AuthenticationInfo info = (AuthenticationInfo) config.get(name);
      return info;
   }
   public AuthenticationInfo remove(String name)
   {
      AuthenticationInfo info = (AuthenticationInfo) config.remove(name);
      return info;
   }
   public void clear()
   {
      config.clear();
   }
   public Set getConfigNames()
   {
      return config.keySet();
   }
   public int size()
   {
      return config.size();
   }
   public boolean containsKey(String name)
   {
      return config.containsKey(name);
   }
   public void copy(PolicyConfig pc)
   {
      config.putAll(pc.config);
   }
}
