/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.security.auth.login;

import javax.management.ObjectName;

import org.jboss.system.ServiceMBean;

/** The management interface for the DynamicLoginConfig service.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public interface DynamicLoginConfigMBean
   extends ServiceMBean
{
   /** Get the resource path to the JAAS login configuration file to use.
    */
   public String getAuthConfig();
   /** Set the resource path to the JAAS login configuration file to use.
    * @param authConf - the classpath resource to load.
    */
   public void setAuthConfig(String authConf);

   /** Get the XMLLoginConfig service to use for loading.
    * @return the XMLLoginConfig service name.
    */ 
   public ObjectName getLoginConfigService();
   /** Get the XMLLoginConfig service to use for loading. This service must
    * support a String[] loadConfig(URL) operation to load the configurations. 
    * 
    * @param serviceName - the XMLLoginConfig service name.
    */ 
   public void setLoginConfigService(ObjectName serviceName);

   /** Flush the caches of the security domains that have been registered
    * by this service.
    * @throws Exception
    */ 
   public void flushAuthenticationCaches() throws Exception;

   /** Get the SecurityManagerService used to flush the registered security
    * domains.
    * @return the SecurityManagerService service name.
    */
   public ObjectName getSecurityManagerService();

   /** Set the SecurityManagerService used to flush the registered security
    * domains. This service must support an flushAuthenticationCache(String)
    * operation to flush the case for the argument security domain. Setting
    * this triggers the flush of the authentication caches when the service
    * is stopped.
    * @param serviceName - the SecurityManagerService service name.
    */
   public void setSecurityManagerService(ObjectName serviceName);

}
