/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.security.auth.certs;

import java.security.Principal;
import java.security.cert.X509Certificate;
import org.jboss.security.CertificatePrincipal;

/** A CertificatePrincipal implementation that uses the client cert
 * SubjectDN as the principal.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class SubjectDNMapping
   implements CertificatePrincipal
{
   /** Returns the client cert SubjectDN as the principal.
    *
    * @param certs Array of client certificates, with the first one in
    * the array being the certificate of the client itself.
    */
   public Principal toPrinicipal(X509Certificate[] certs)
   {
      Principal subject = certs[0].getSubjectDN();
      return subject;
   }
}
