/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.samples.detection;

import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.detection.multicast.MulticastDetector;
import org.jboss.remoting.network.NetworkNotification;
import org.jboss.remoting.network.NetworkRegistry;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

/**
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class SimpleDetectorClient implements NotificationListener
{
   public void setupDetector() throws Exception
   {
      MBeanServer server = MBeanServerFactory.createMBeanServer();

      NetworkRegistry registry = NetworkRegistry.getInstance();
      server.registerMBean(registry, new ObjectName("remoting:type=NetworkRegistry"));

      // register class as listener, so know when new server found
      registry.addNotificationListener(this, null, null);

      MulticastDetector detector = new MulticastDetector();
      server.registerMBean(detector, new ObjectName("remoting:type=MulticastDetector"));
      detector.start();
   }

   /**
    * Callback method from the broadcaster MBean this listener implementation
    * is registered to.
    *
    * @param notification the notification object
    * @param handback     the handback object given to the broadcaster
    *                     upon listener registration
    */
   public void handleNotification(Notification notification, Object handback)
   {
      if(notification instanceof NetworkNotification)
      {
         NetworkNotification networkNotification = (NetworkNotification) notification;
         InvokerLocator[] locators = networkNotification.getLocator();
         for(int x = 0; x < locators.length; x++)
         {
            try
            {
               makeInvocation(locators[x].getLocatorURI());
            }
            catch(Throwable throwable)
            {
               throwable.printStackTrace();
            }
         }
      }
   }

   public void makeInvocation(String locatorURI) throws Throwable
   {
      InvokerLocator locator = new InvokerLocator(locatorURI);
      System.out.println("Calling remoting server with locator uri of: " + locatorURI);

      Client remotingClient = new Client(locator);
      Object response = remotingClient.invoke("Do something", null);

      System.out.println("Invocation response: " + response);
   }

   public static void main(String[] args)
   {
      SimpleDetectorClient client = new SimpleDetectorClient();
      try
      {
         client.setupDetector();

         // sleep the thread for 10 seconds while waiting detection
         Thread.sleep(10000);

      }
      catch(Throwable e)
      {
         e.printStackTrace();
      }
   }


}