/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.performance.oneway;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Level;
import org.jboss.remoting.performance.PerformanceInvokerServer;
import org.jboss.remoting.performance.PerformanceTest;

/**
 * This should be used as the main test case for the oneway invoker client/server.
 * It will start one instance of the client and one of the server and will
 * gather the test results and report them in standard JUnit format.  When
 * wanting to run JUnit test for oneway invoker, this is the class to use.
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class ServerOnewayInvocationTestCase extends PerformanceTest
{
   public ServerOnewayInvocationTestCase(String name)
   {
      super(name);
   }


   public String getClientFQN()
   {
      return ServerOnewayInvocationTest.class.getName();
   }

   public String getServerFQN()
   {
      return PerformanceInvokerServer.class.getName();
   }

   public static Test suite()
   {
      return new TestSuite(ServerOnewayInvocationTestCase.class);
   }

   public static void main(String[] args)
   {
      org.apache.log4j.BasicConfigurator.configure();
      org.apache.log4j.Category.getRoot().setLevel(Level.INFO);
      org.apache.log4j.Category.getInstance("org.jgroups").setLevel(Level.INFO);
      org.apache.log4j.Category.getInstance("org.jboss.remoting").setLevel(Level.DEBUG);
      org.apache.log4j.Category.getInstance("test").setLevel(Level.DEBUG);

      TestRunner.run(suite());
      System.exit(0);
   }


}