/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.remoting.marshall.dynamic.local;

import org.jboss.remoting.InvokerLocator;

/**
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public interface MarshallerLoadingConstants
{
   // Default locator values
   static String transport = "socket";
   static String host = "localhost";
   static int port = 5300;

   static String dataType = "test";
   static String locatorURI = transport + "://" + host + ":" + port + "/?" +
                              InvokerLocator.DATATYPE + "=" + dataType + "&" +
                              InvokerLocator.MARSHALLER + "=" + "org.jboss.remoting.marshall.dynamic.local.TestMarshaller" + "&" +
                              InvokerLocator.UNMARSHALLER + "=" + "org.jboss.remoting.marshall.dynamic.local.TestUnMarshaller";
}
