/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.remoting.interceptor;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;

import java.io.Serializable;

/**
 * Just extending InvocationBase and using implementation from
 * MethodCallByMethodInvocation for the getWrapper() and copy() methods.
 * Just need a simple invocation instance for testing.
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class TestInvocation extends InvocationBase implements Serializable
{
   private Object arg;

   public TestInvocation(Interceptor[] interceptorStack)
   {
      super(interceptorStack);
   }

   /**
    * Get a wrapper invocation object that can insert a new chain of interceptors
    * at runtime to the invocation flow.  CFlow makes use of this.
    * When the wrapper object finishes its invocation chain it delegates back to
    * the wrapped invocation.
    *
    * @param newchain
    * @return
    */
   public Invocation getWrapper(Interceptor[] newchain)
   {
      int size = interceptors.length + newchain.length;
      Interceptor[] newInterceptors = new Interceptor[size];
      size = 0;
      for(int i = 0; i < interceptors.length; i++, size++)
      {
         newInterceptors[i] = interceptors[i];
      }
      for(int x = 0; x < newchain.length; x++, size++)
      {
         newInterceptors[x] = newchain[x];
      }
      TestInvocation newInvocation = new TestInvocation(newInterceptors);
      newInvocation.setMetaData(getMetaData());
      newInvocation.setArgument(getArgument());
      return newInvocation;
   }

   /**
    * Copies complete state of Invocation object so that it could possibly
    * be reused in a spawned thread.
    *
    * @return
    */
   public Invocation copy()
   {
      return getWrapper(new Interceptor[0]);
   }

   public void setArgument(Object testTarget)
   {
      this.arg = testTarget;
   }

   public Object getArgument()
   {
      return arg;
   }
}
