/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.detection.jndi;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Level;
import org.jboss.dtf.DistributedTestCase;
import org.jgroups.Address;
import org.jnp.server.Main;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * This should be used as the main test case for JNDI detector.
 * It will start two JNDIDetectors in seperate instances.  The first
 * will detect the second and then the second will shutdown and the first
 * will detect that the second is no longer present.  This also requires
 * this class to start an instance of the JNP
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class JNDIDetectorTestCase extends DistributedTestCase
{
   private List results = new ArrayList();

   public JNDIDetectorTestCase(String name)
   {
      super(name);
   }

   protected void setUp() throws Exception
   {
      int instances = 3;
      int port = 1099;
      String host = InetAddress.getLocalHost().getHostName();

      startJNP(port, host);

      String clientcmd = "java -cp " + System.getProperty("java.class.path") +
//                          " -Djboss.mx.instanceid.dir=" + System.getProperty("jboss.mx.instanceid.local.dir") +
                         " " + JNDIDetectorTest1.class.getName() + " " + instances + " " +
                         port + " " + host;
      System.out.println("clientcmd: " + clientcmd);
      String svrcmd = "java -cp " + System.getProperty("java.class.path") +
//                          " -Djboss.mx.instanceid.dir=" + System.getProperty("jboss.mx.instanceid.remote.dir") +
                      " " + JNDIDetectorTest2.class.getName() + " " + instances + " " +
                      port + " " + host;
      System.out.println("svrcmd: " + svrcmd);

      final Process local = Runtime.getRuntime().exec(clientcmd);
      final Process remote = Runtime.getRuntime().exec(svrcmd);

   }

   /**
    * Have to start a JNDI server so both the JNDIDetectorTests have
    * a server to connect to.
    *
    * @param port
    * @param host
    * @throws Exception
    */
   private void startJNP(int port, String host) throws Exception
   {
      // start JNDI server
      Main JNDIServer = new Main();
      JNDIServer.setPort(port);
      JNDIServer.setBindAddress(host);
      JNDIServer.start();
      System.out.println("Started JNDI server on " + host + ":" + port);
   }

   protected void tearDown() throws Exception
   {
      //NO OP
   }

   public void testInvokers()
   {
      try
      {
         startup(3);
         System.out.println("startup() called");
         shutdown();
         System.out.println("shutdown() called");
      }
      catch(Exception e)
      {
         e.printStackTrace();
         assertTrue("Problem starting or stopping client/server processes.", false);
      }
      finally
      {
         // assert results
         try
         {
            Thread.currentThread().sleep(120000);
         }
         catch(InterruptedException e)
         {
            e.printStackTrace();
         }
         System.out.println("results.size() = " + results.size());
         if(results.size() > 0)
         {
            Iterator itr = results.iterator();
            while(itr.hasNext())
            {
               String message = (String) itr.next();
               assertTrue(message, false);
            }
         }
         else
         {
            assertTrue("No test failures or errors.", true);
         }

      }
   }

   /**
    * **********************************
    * Driver callback for JUnit asserts *
    * ***********************************
    */
   public void receiveAssert(Address source, String message)
   {
      super.receiveAssert(source, message);
      results.add("Assert source: " + source + "\tmessage: " + message);
   }

   public static Test suite()
   {
      return new TestSuite(JNDIDetectorTestCase.class);
   }

   public static void main(String[] args)
   {

      org.apache.log4j.BasicConfigurator.configure();
      org.apache.log4j.Category.getRoot().setLevel(Level.DEBUG);

      //MultipleTestRunner runner = new MultipleTestRunner();
      //runner.doRun(test, true);
      TestRunner.run(suite());
//        System.exit(0);
   }


}