/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting;

import org.jboss.dtf.DistributedTestCase;

/**
 * Used as base for the client and server invoker test since they
 * share many of the same behaviors.
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public abstract class AbstractInvokerTest extends DistributedTestCase
{
   protected int port = 8081;
   protected String transport = "socket";

   public AbstractInvokerTest(String name)
   {
      super(name);
   }

   public AbstractInvokerTest(String name, int numberOfInstances)
   {
      super(name);
      init(numberOfInstances);
   }

   public AbstractInvokerTest(String name, String transport, int port)
   {
      super(name);
      this.transport = transport;
      this.port = port;
   }

   public AbstractInvokerTest(String name, String transport, int port, int numberOfInstances)
   {
      super(name);
      this.transport = transport;
      this.port = port;
      init(numberOfInstances);
   }

   public String getTransport()
   {
      return transport;
   }

   public int getPort()
   {
      return port;
   }
}
