/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.transport.socket;

import org.jboss.remoting.ServerInvokerMBean;

/**
 * MBean interface.
 */
public interface SocketServerInvokerMBean extends ServerInvokerMBean
{

   /**
    * Starts the invoker.
    */
   void start() throws java.io.IOException;

   /**
    * Stops the invoker.
    */
   void stop();

   /**
    * Getter for property timeout
    *
    * @return Value of property timeout
    */
   int getSocketTimeout();

   /**
    * Setter for property timeout
    *
    * @param time New value of property timeout
    */
   void setSocketTimeout(int time);

   int getCurrentThreadPoolSize();

   int getCurrentClientPoolSize();

   java.lang.String getClientConnectAddress();

   /**
    * This method should only be called by the service controller when this invoker is specified within the Connector configuration of a service xml. Calling this directly will have no effect, as will be used in building the locator uri that is published for detection and this happens when the invoker is first created and started (after that, no one will be aware of a change).
    */
   void setClientConnectAddress(java.lang.String clientConnectAddress);

   /**
    * Getter for property numAcceptThreads
    *
    * @return The number of threads that exist for accepting client connections
    */
   int getNumAcceptThreads();

   /**
    * Setter for property numAcceptThreads
    *
    * @param size The number of threads that exist for accepting client connections
    */
   void setNumAcceptThreads(int size);

   /**
    * Setter for max pool size. The number of server threads for processing client. The default is 300.
    *
    * @return
    */
   int getMaxPoolSize();

   /**
    * The number of server threads for processing client. The default is 300.
    *
    * @param maxPoolSize
    */
   void setMaxPoolSize(int maxPoolSize);

   java.lang.String getServerBindAddress();

   void setServerBindAddress(java.lang.String serverBindAddress);

   /**
    * Getter for property serverBindPort.
    *
    * @return Value of property serverBindPort.
    */
   int getServerBindPort();

   /**
    * Setter for property serverBindPort.
    *
    * @param serverBindPort New value of property serverBindPort.
    */
   void setServerBindPort(int serverBindPort);

   int getBacklog();

   void setBacklog(int backlog);

}
