/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.network.filter;

import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ident.Identity;
import org.jboss.remoting.network.NetworkFilter;

/**
 * IdentityFilter
 * 
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision:1$
 */
public class IdentityFilter implements NetworkFilter
{
    private final Identity identity;

    public IdentityFilter (Identity identity)
    {
        this.identity = identity;
    }

    /**
     * called to apply a filter when selecting <tt>0..*</tt> servers on the network
     *
     * @param identity
     * @param locators
     * @return
     */
    public boolean filter ( Identity identity, InvokerLocator locators[] )
    {
        return identity.equals(this.identity);
    }
}
