/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.marshal.serializable;

import org.jboss.remoting.marshal.Marshaller;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

/**
 * Simple marshaller that simply serializes java objects
 * using standard output stream.
 *
 * @author <a href="mailto:tom@jboss.org">Tom Elrod</a>
 */
public class SerializableMarshaller implements Marshaller
{
   public final static String DATATYPE = "serializable";

   /**
    * Take the data object and write to the output.  Has ben customized
    * for working with ObjectOutputStreams since requires extra messaging.
    *
    * @param dataObject Object to be writen to output
    * @param output     The data output to write the object
    *                   data to.
    */
   public void write(Object dataObject, OutputStream output) throws IOException
   {
      ObjectOutputStream oos = null;
      if(output instanceof ObjectOutputStream)
      {
         oos = (ObjectOutputStream) output;
      }
      else
      {
         oos = new ObjectOutputStream(output);
      }
      oos.writeObject(dataObject);

      oos.reset();
      // to make sure stream gets reset
      // Stupid ObjectInputStream holds object graph
      // can only be set by the client/server sending a TC_RESET
      oos.writeObject(Boolean.TRUE);
      oos.flush();
      oos.reset();

   }
}