/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.marshal.http;

import org.jboss.remoting.marshal.serializable.SerializableMarshaller;

import java.io.IOException;
import java.io.OutputStream;

/**
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class HTTPMarshaller extends SerializableMarshaller
{
   public final static String DATATYPE = "http";

   /**
    * Take the data object and write to the output.
    * If the data object is of type String, will just
    * write the bytes of the String, otherwise will
    * use the SerializableMarshaller implementation.
    *
    * @param dataObject Object to be writen to output
    * @param output     The data output to write the object
    *                   data to.
    */
   public void write(Object dataObject, OutputStream output) throws IOException
   {
      if (dataObject instanceof String)
      {
         output.write(((String) dataObject).getBytes());
         output.flush();
      }
      else
      {
         super.write(dataObject, output);
      }
   }
}