/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.marshal;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;

/**
 * Takes a marshalled byte array and converts to a Java
 * data object.
 *
 * @author <a href="mailto:tom@jboss.org">Tom Elrod</a>
 */
public interface UnMarshaller extends Serializable
{
   /**
    * Will read from the inputstream and converty contents to java Object.
    *
    * @param inputStream stream to read data from to do conversion
    * @param metadata    can be any transport specific metadata (such as headers from http transport).
    *                    This can be null, depending on if transport supports metadata.
    * @return
    * @throws IOException            all specific i/o exceptions need to be thrown as this.
    * @throws ClassNotFoundException will be thrown if during the unmarshalling process can not find a specific class
    *                                within classloader.
    */
   public Object read(InputStream inputStream, Map metadata) throws IOException, ClassNotFoundException;

   /**
    * Set the class loader to use for unmarhsalling.  This may
    * be needed when need to have access to class definitions that
    * are not part of this unmarshaller's parent classloader (especially
    * when doing remote classloading).
    *
    * @param classloader
    */
   public void setClassLoader(ClassLoader classloader);

}