/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.marshal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

/**
 * Interface that all data marshallers must implements.
 * Requires them to take Java data objects and convert
 * primitive java data types (i.e. byte[]) and write
 * to output provided.
 * <p/>
 * Since the Marshaller is only responsible for doing
 * the conversion to primitive type, does not make sense
 * that would be supplied any type of object output to
 * write to, as this implies that the object that it
 * writes would be converted to bytes at some other
 * point external to the marshaller.
 *
 * @author <a href="mailto:tom@jboss.org">Tom Elrod</a>
 */
public interface Marshaller extends Serializable
{
   /**
    * Marshaller will need to take the dataObject and convert
    * into primitive java data types and write to the
    * given output.
    *
    * @param dataObject Object to be writen to output
    * @param output     The data output to write the object
    *                   data to.
    */
   public void write(Object dataObject, OutputStream output) throws IOException;

}