/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.remoting.detection;

import org.jboss.system.ConfigurationException;
import org.w3c.dom.Element;
import org.jboss.system.ConfigurationException;

/**
 * This provides a MBean accessible interface for setting domain configuration
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public interface AbstractDetectorMBean
{
    /**
     * set the configuration for the domains to be recognized by detector
     *
     * @param xml
     *
     * @jmx.managed-attribute description="Domains is an xml element indicating domains to be recognized by detector"
     *     access="read-write"
     */
    public void setConfiguration(Element xml) throws Exception;

    /**
     * The <code>getDomains</code> method
     *
     * @return an <code>Element</code> value
     *
     * @jmx.managed-attribute
     */
    public Element getConfiguration();

   /**
    * The amount of time to wait between sending (and sometimes receiving) detection messages.
    * @param heartbeatTimeDelay
    * @throws org.jboss.system.ConfigurationException
    */
   void setHeartbeatTimeDelay(long heartbeatTimeDelay) throws ConfigurationException;

   /**
    * The amount of time to wait between sending (and sometimes receiving) detection messages.
    * @return
    */
   long getHeartbeatTimeDelay();

   /**
    * The amount of time which can elapse without receiving a detection event before a server
    * will be suspected as being dead and peroforming an explicit invocation on it to verify it is alive.
    * @param defaultTimeDelay time in milliseconds
    * @throws org.jboss.system.ConfigurationException
    */
   void setDefaultTimeDelay(long defaultTimeDelay) throws ConfigurationException;

   /**
    *
    * @return The amount of time which can elapse without receiving a detection event before a server
    * will be suspected as being dead and peroforming an explicit invocation on it to verify it is alive.
    */
   long getDefaultTimeDelay();
}
