/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting;

/**
 * SubsystemNotSupported is raised by a ServerInvoker when the target subsystem is not
 * supported on the target VM.
 * 
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision:1$
 */
public class SubsystemNotSupported extends Exception
{
    private String subsystem;
    private InvokerLocator locator;

    public SubsystemNotSupported (String subsystem, InvokerLocator locator)
    {
        super("Subsystem '"+subsystem+"' not supported on target VM ("+locator+")");
        this.subsystem = subsystem;
        this.locator = locator;
    }
    public String getSubsystem ()
    {
        return subsystem;
    }
    public InvokerLocator getLocator ()
    {
        return locator;
    }
}
