/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.remoting;

import java.io.IOException;
import java.util.Map;

/**
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public interface ServerInvokerMBean
{
   /**
    * Will get the data type for the marshaller factory so know which marshaller to
    * get to marshal the data.  Will first check the locator uri for a 'datatype'
    * parameter and take that value if it exists.  Otherwise, will use the
    * default datatype for the client invoker, based on transport.
    *
    * @return
    */
   String getDataType();

   /**
    * returns true if the transport is bi-directional in nature, for example,
    * SOAP in unidirectional and SOCKETs are bi-directional (unless behind a firewall
    * for example).
    *
    * @return
    */
   boolean isTransportBiDirectional();

   /**
    * subclasses should override to provide any specific start logic
    *
    * @throws java.io.IOException
    */
   void start() throws IOException;

   /**
    * return true if the server invoker is started, false if not
    *
    * @return
    */
   boolean isStarted();

   /**
    * subclasses should override to provide any specific stop logic
    */
   void stop();

   /**
    * destory the invoker permanently
    */
   void destroy ();

   /**
    * Sets the server invoker's transport specific configuration.  Will need to set before calling
    * start() method (or at least stop() and start() again) before configurations will take affect.
    *
    * @param configuration
    */
   void setConfigration(Map configuration);

   /**
    * Gets teh server invoker's transport specific configuration.
    *
    * @return
    */
   Map getConfiguration();
}
