/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;


/**
 * InvocationResponse is a return object from a call to a remote Server Invoker.
 * The InvocationResponse may contain either an Exception or a result value (which may be
 * null in the case the user returns null)
 *
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 * @version $Revision:1$
 */
public class InvocationResponse implements Serializable
{
   static final long serialVersionUID = 1324503813652865685L;

   private final String sessionId;
   private final boolean isException;
   private final Object result;
   private Map payload;

   public InvocationResponse(String sessionId, Object result, boolean isException, Map payload)
         throws IOException
   {
      this.sessionId = sessionId;
      this.isException = isException;
      this.result = result;
      this.payload = payload;
   }

   public String getSessionId()
   {
      return sessionId;
   }

   public Map getPayload()
   {
      return payload;
   }

   public boolean isException()
   {
      return isException;
   }

   public Object getResult()
   {
      return result;
   }
}
