/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting;

/**
 * This exception is generated when the remoting layer cannot connect to the remote server
 * It means that the client cannot send the request to the server.
 * <p/>
 * Clustering layers can rely this exception to failover.
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision:1$
 */
public class CannotConnectException extends RuntimeException
{
   public CannotConnectException()
   {
   }

   public CannotConnectException(String message)
   {
      super(message);
   }

   public CannotConnectException(String message, Throwable cause)
   {
      super(message, cause);
   }

   public CannotConnectException(Throwable cause)
   {
      super(cause);
   }
}
