/*
 * JBossMQ, the OpenSource JMS implementation
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.mq.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

import org.jboss.mq.Subscription;

/**
 * The default implementation of the Receivers interface.
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class ReceiversImplLinkedList implements Receivers
{
   // Constants -----------------------------------------------------

   // Attributes ----------------------------------------------------

   /** The receivers */
   LinkedList receivers = new LinkedList();
   
   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------

   // Public --------------------------------------------------------

   // Receivers implementation --------------------------------------

   public void add(Subscription sub)
   {
      receivers.add(sub);
   }
   
   public Iterator iterator()
   {
      return receivers.iterator();
   }
   
   public ArrayList listReceivers()
   {
      return new ArrayList(receivers);
   }
   
   public void remove(Subscription sub)
   {
      receivers.remove(sub);
   }
   
   public int size()
   {
      return receivers.size();
   }
   
   // Protected -----------------------------------------------------
   
   // Package Private -----------------------------------------------

   // Private -------------------------------------------------------

   // Inner classes -------------------------------------------------
}
