/*
 * JBossMQ, the OpenSource JMS implementation
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package org.jboss.mq;

import java.io.Serializable;

import javax.jms.Queue;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

/**
 * This class implements javax.jms.Queue
 * 
 * @author Norbert Lataille (Norbert.Lataille@m4x.org)
 * @author Hiram Chirino (Cojonudo14@hotmail.com)
 * @author David Maplesden (David.Maplesden@orion.co.nz)
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version $Revision:1$
 */
public class SpyQueue extends SpyDestination implements Serializable, Queue, Referenceable
{
   // Constants -----------------------------------------------------

   /** The serialVersionUID */
   static final long serialVersionUID = 3040902899515975733L;
   
   // Attributes ----------------------------------------------------

   /** added cached toString string for efficiency */
   private String toStringStr;
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------

   
   /**
    * Create a new SpyQueue
    *
    * @param queueName the queue name
    */
   public SpyQueue(String queueName)
   {
      super(queueName);
      toStringStr = "QUEUE." + name;
      hash++;
   }
   
   // Public --------------------------------------------------------
   
   // Queue implementation ------------------------------------------

   public String getQueueName()
   {
      return name;
   }
   
   // Referenceable implementation ----------------------------------

   public Reference getReference() throws javax.naming.NamingException
   {

      return new Reference("org.jboss.mq.SpyQueue", new StringRefAddr("name", name),
            "org.jboss.mq.referenceable.SpyDestinationObjectFactory", null);
   }

   // Object overrides ----------------------------------------------

   public String toString()
   {
      return toStringStr;
   }
   
   public boolean equals(Object obj)
   {
      if (!(obj instanceof SpyQueue))
         return false;
      if (obj.hashCode() != hash)
         return false;
      return ((SpyQueue) obj).name.equals(name);
   }
   
   // Package protected ---------------------------------------------
   
   // Protected -----------------------------------------------------
   
   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------
}