/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.media.registry;

import java.util.Iterator;
import java.util.Map;

import javax.emb.FormatAlreadyBoundException;
import javax.emb.FormatNotFoundException;
import javax.emb.MediaFormat;

import org.jboss.system.ServiceMBeanSupport;

/**
 * A managed implementation of a MediaFormat registry.
 *
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:spyridon_samothrakis@yahoo.com">Spyridon Samothrakis</a>
 *
 * @jmx.mbean extends="org.jboss.system.ServiceMBean"
 */
public class ManagedMediaFormatRegistry
   extends ServiceMBeanSupport
   implements ManagedMediaFormatRegistryMBean
{
   private SimpleMediaFormatRegistry mediaFormatRegistry;

   /**
    * Public Constructor.
    */
   public ManagedMediaFormatRegistry()
   {
   }

   /**
    * @jmx.managed-operation
    */
   public void bind(String fileExtension, MediaFormat mediaFormat)
      throws FormatAlreadyBoundException
   {
      mediaFormatRegistry.bind(fileExtension, mediaFormat);
   }

   /**
    * @jmx.managed-operation
    */
   public void rebind(String fileExtension, MediaFormat mediaFormat)
   {
      mediaFormatRegistry.rebind(fileExtension, mediaFormat);
   }

   /**
    * @jmx.managed-operation
    */
   public void unbind(String fileExtension) throws FormatNotFoundException
   {
      mediaFormatRegistry.unbind(fileExtension);
   }

   /**
    * @jmx.managed-operation
    */
   public MediaFormat lookup(String fileExtension)
      throws FormatNotFoundException
   {
      return mediaFormatRegistry.lookup(fileExtension);
   }

   /**
    * @jmx.managed-operation
    */
   public Iterator fileExtensions()
   {
      return mediaFormatRegistry.fileExtensions();
   }

   /**
    * @see org.jboss.system.ServiceMBeanSupport#createService()
    */
   protected void createService() throws Exception
   {
      Map mediaFormats = JBossMediaFormatRegistry.createMediaFormats();
      mediaFormatRegistry = new SimpleMediaFormatRegistry(mediaFormats);
   }

   /**
    * @see org.jboss.system.ServiceMBeanSupport#destroyService()
    */
   protected void destroyService() throws Exception
   {
   }

   /**
    * @see org.jboss.system.ServiceMBeanSupport#startService()
    */
   protected void startService() throws Exception
   {
   }

   /**
    * @see org.jboss.system.ServiceMBeanSupport#stopService()
    */
   protected void stopService() throws Exception
   {
   }
}
