/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.media.registry;

import java.util.Iterator;
import java.util.Map;

import javax.emb.FormatAlreadyBoundException;
import javax.emb.FormatNotFoundException;
import javax.emb.MediaFormat;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

import org.jboss.media.format.audio.mpeg.MpegAudioFormat;
import org.jboss.media.format.image.iio.IIOMediaFormatFactory;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanProxyCreationException;

/**
 * A facade around SimpleMediaFormatRegistry or ManagedMediaFormatRegistry.
 *
 * SimpleMediaFormatRegistry is simpler to test.
 * ManagedMediaFormatRegistry should be used in deployment.
 *
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo Argello</a>
 * @author <a href="mailto:spyridon_samothrakis@yahoo.com">Spyridon Samothrakis</a>
 */
public class JBossMediaFormatRegistry
{
   // Simple MediaFormats registry:
   private SimpleMediaFormatRegistry mediaFormatRegistry;

   // Managed MediaFormats registry (uncomment to use this version):
   //public static final ManagedMediaFormatRegistryMBean mediaFormatRegistry = getInstance();
   // All these are needed by the managed registry:
   private static final String OBJECT_NAME =
      "jboss.emb:service=ManagedMediaFormatRegistry";
   private static boolean INITIALIZED = false;
   private static MBeanServer SERVER;

   /**
    * Default constructor.
    */
   public JBossMediaFormatRegistry() throws FormatAlreadyBoundException
   {
      Map mediaFormats = createMediaFormats();
      mediaFormatRegistry = new SimpleMediaFormatRegistry(mediaFormats);
   }

   public void bind(String fileExtension, MediaFormat mediaFormat)
      throws FormatAlreadyBoundException
   {
      mediaFormatRegistry.bind(fileExtension, mediaFormat);
   }

   public void rebind(String fileExtension, MediaFormat mediaFormat)
   {
      mediaFormatRegistry.rebind(fileExtension, mediaFormat);
   }

   public void unbind(String fileExtension) throws FormatNotFoundException
   {
      mediaFormatRegistry.unbind(fileExtension);
   }

   public MediaFormat lookup(String fileExtension)
      throws FormatNotFoundException
   {
      return mediaFormatRegistry.lookup(fileExtension);
   }

   public Iterator getFileExtensions()
   {
      return mediaFormatRegistry.fileExtensions();
   }

   //-------------------------------------------------------------
   private static ManagedMediaFormatRegistryMBean getInstance()
   {
      try
      {
         ObjectName objectName = new ObjectName(OBJECT_NAME);
         return (ManagedMediaFormatRegistryMBean) MBeanProxy.get(
            ManagedMediaFormatRegistryMBean.class,
            objectName,
            SERVER);
      }
      catch (MalformedObjectNameException e)
      {
         return null;
      }
      catch (MBeanProxyCreationException e)
      {
         return null;
      }
   }

   public static Map createMediaFormats()
   {
      // Image I/O support:
      Map mediaFormats = IIOMediaFormatFactory.createMediaFormats();

      // MPEG support:
      mediaFormats.put("mp3", new MpegAudioFormat());

      return mediaFormats;
   }
}
