/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.media.format.image.iio;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.imageio.ImageIO;
import javax.imageio.ImageReader;

/**
 * Creates <code>MediaFormat</code>s based on the Java Image I/O API.
 *
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo Argello</a>
 */
public class IIOMediaFormatFactory
{
   public static Map createMediaFormats()
   {
      Map mediaFormats = new HashMap();

      // PNG:
      Iterator imageReaders = ImageIO.getImageReadersByFormatName("png");
      ImageReader imageReader = (ImageReader) imageReaders.next();
      mediaFormats.put("png", new PNGMediaFormat(imageReader));

      /*ImageReader pngImageReader = getImageReaderByFormatName("png");
      ImageReader jpegImageReader = getImageReaderByFormatName("jpeg");
      ImageReader gifImageReader = getImageReaderByFormatName("gif");

      // StandardMediaFormat (just testing):
      mediaFormats.put("png", new StandardMediaFormat(pngImageReader));
      mediaFormats.put("jpeg", new StandardMediaFormat(jpegImageReader));
      mediaFormats.put("gif", new StandardMediaFormat(gifImageReader));*/

      return mediaFormats;
   }

   private static ImageReader getImageReaderByFormatName(String formatName)
   {
      Iterator imageReaders = ImageIO.getImageReadersByFormatName(formatName);
      return (ImageReader) imageReaders.next();
   }
}
