/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.media.format.audio.oggvorbis;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import javax.emb.MediaException;
import javax.emb.MediaHeader;

/**
 * Represents an Ogg Vorbis header.
 * 
 * <p>More info at <a href="http://www.vorbis.com/">www.vorbis.com</a> and
 * <a href="http://www.xiph.org/ogg/vorbis/">www.xiph.org/ogg/vorbis</a>.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo Argello</a>
 */
public class OggVorbisHeader implements MediaHeader
{
   // Field name keys for fields map
   private final static String CHANNELS_KEY = "channels";
   private final static String RATE_KEY = "rate";
   private final static String BITRATE_KEY = "bitRate";
   private final static String COMMENTS_KEY = "comments";

   // Map to hold fields in
   private final Map fieldMap = new HashMap(4);

   /**
    * Default constructor
    */
   public OggVorbisHeader(InputStream content) throws MediaException
   {
      try
      {
         // Extract metadata
         VorbisInfo info = new VorbisInfo(content);

         fieldMap.put(CHANNELS_KEY, new Integer(info.getChannels()));
         fieldMap.put(RATE_KEY, new Long(info.getRate()));
         fieldMap.put(BITRATE_KEY, new Long(info.getBitrate()));
         fieldMap.put(COMMENTS_KEY, info.getComments());
      }
      catch (IOException e)
      {
         throw new MediaException("Error creating VorbisInfo helper object", e);
      }
   }

   /**
    * @see javax.emb.MediaHeader#getFieldNames()
    */
   public String[] getFieldNames()
   {
      return (String[]) fieldMap.keySet().toArray(new String[0]);
   }

   /**
    * @see javax.emb.MediaHeader#getField(java.lang.String)
    */
   public Object getField(String fieldName)
   {
      return fieldMap.get(fieldName);
   }
}