/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package org.jboss.media.format;

import java.io.InputStream;
import java.net.URL;

import javax.emb.GenericMediaFormat;
import javax.emb.Media;
import javax.emb.MediaException;
import javax.emb.MediaFormat;
import javax.emb.MediaHeader;
import javax.emb.MediaSegment;

/**
 * Facade around <code>GenericMediaFormat</code> to represent embedded media
 * formats.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public abstract class EmbeddedMediaFormat implements MediaFormat
{
   private MediaFormat mediaFormat;

   public EmbeddedMediaFormat()
   {
      mediaFormat = new GenericMediaFormat();
   }

   public final byte[] assembleContent(
      URL mediaLocation,
      MediaSegment[] mediaSegments)
      throws MediaException
   {
      return mediaFormat.assembleContent(mediaLocation, mediaSegments);
   }

   public final MediaSegment[] disassembleContent(
      URL mediaLocation,
      byte[] mediaContent)
      throws MediaException
   {
      return mediaFormat.disassembleContent(mediaLocation, mediaContent);
   }

   public abstract MediaHeader extractHeader(InputStream content)
      throws MediaException;

   public Media extractProxy(InputStream content) throws MediaException
   {
      return mediaFormat.extractProxy(content);
   }

   public abstract String getDefaultMimeType();

   public final boolean isEmbedded()
   {
      return true;
   }

   public abstract boolean isStreamingDesirable();
}
