/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.media.engine;

import java.util.Iterator;
import java.util.Vector;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanProxyCreationException;
import org.jboss.system.ServiceMBeanSupport;


/**
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:spyridon_samothrakis@yahoo.com">Spyridon Samothrakis</a>
 *
 * @jmx.mbean extends="org.jboss.system.ServiceMBean"
 * @jmx.mbean description="Creates MediaPublisher"
 */
public class MediaPublisherFactory
   extends ServiceMBeanSupport
   implements MediaPublisherFactoryMBean
{

   Vector m_publishers = new Vector();

   /**
    * Creates a media publisher according to the parameters passed
    * @jmx.managed-operation description="Creates a MediaPublisher"
    */
   public ObjectName createPublisher(
      String publisherClassName,
      String context,
      String host,
      int port,
      String arguments,
      String fileName)
   {

      System.out.println("IIIIIIIIIIII" + arguments + "IIIIIIIIIIII");

      ObjectName publisherName;

      publisherName = getObjectName(publisherClassName, context);

      // add the bean to the server
      try
      {

         Class publisher = Class.forName(publisherClassName);
         Class publisherMBean = Class.forName(publisherClassName + "MBean");
         MediaPublisherMBean pBean =
            (MediaPublisherMBean) MBeanProxy.create(
               publisher,
               publisherMBean,
               publisherName,
               getServer());

         m_publishers.add(pBean);
         // set initial parameters
         // To be changed in the near future
         pBean.setName(publisherName);
         pBean.setHost(host);
         // mambo number 22224
         pBean.setPort(port);
         pBean.setContext(context);
         pBean.setFileName(fileName);

      }

      catch (MBeanProxyCreationException e)
      {
         log.error("Big Nasty error. Get out o' here ", e);
      }
      catch (ClassNotFoundException e)
      {
         log.error("Publisher class " + publisherClassName + " notFound",e);
      }
      // Should we return a string here ?    
      return publisherName;
   }

   /**
    * Creates a media publisher according to the parameters passed
    * @jmx.managed-operation description="Creates a MediaPublisher"
    */
   public void destroyPublisher(ObjectName name)
   {
      try
      {
         for (Iterator iter = m_publishers.iterator(); iter.hasNext();)
         {
            MediaPublisherMBean element = (MediaPublisherMBean) iter.next();
            if (element.getName().equals(name))
            {
               element.stop();
               server.unregisterMBean(element.getName());
               break;
            }

         }
      }

      catch (InstanceNotFoundException e)
      {
         // TODO Auto-generated catch block
         e.printStackTrace();
      }
      catch (MBeanRegistrationException e)
      {
         // TODO Auto-generated catch block
         e.printStackTrace();
      }
   }

   /**
    * return the objectname that we are goint to use 
    * @jmx.managed-operation description="Creates a MediaPublisher"
    */
   public ObjectName getObjectName(String publisherClassName, String context)
   {
      try
      {
         return new ObjectName(
            "jboss.media.engine:service=Media,Type="
               + publisherClassName
               + ",Context="
               + context);
      }
      catch (MalformedObjectNameException e)
      {
         log.error(e);
      }
      catch (NullPointerException e)
      {
         // TODO Auto-generated catch block
         log.error(e);
      }

      return null;
   }
   

   /**
    * @see org.jboss.system.ServiceMBeanSupport#createService()
    */
   protected void createService() throws Exception
   {
   }

   /**
    * @see org.jboss.system.ServiceMBeanSupport#destroyService()
    */
   protected void destroyService() throws Exception
   {
      // if I go down all  of what I have deployed goes down!!!
      for (Iterator iter = m_publishers.iterator(); iter.hasNext();)
      {
         MediaPublisherMBean element = (MediaPublisherMBean) iter.next();
         element.stop();
         server.unregisterMBean(element.getName());
      }

   }

   /**
    * @see org.jboss.system.ServiceMBeanSupport#startService()
    */
   protected void startService() throws Exception
   {
   }

   /**
    * @see org.jboss.system.ServiceMBeanSupport#stopService()
    */
   protected void stopService() throws Exception
   {
   }

}
