/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.media.emb;

import java.net.URL;

import org.dom4j.io.SAXReader;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.ejb.EJBDeployer;
import org.jboss.ejb.EJBDeployerMBean;
import org.jboss.media.engine.MediaXmlLoader;

/**
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:spyridon_samothrakis@yahoo.com">Spyridon Samothrakis</a>
 * @jmx:mbean extends="org.jboss.ejb.EJBDeployerMBean"
 */
public class EMBDeployer
   extends EJBDeployer
   implements EMBDeployerMBean, EJBDeployerMBean
{

   public boolean accepts(DeploymentInfo di)
   {
      // To be accepted the deployment's root name must end in jar
      String urlStr = di.url.getFile();
      if (!urlStr.endsWith("jar") && !urlStr.endsWith("jar/"))
      {
         return false;
      }

      // jar must contain ejb-jar.xml and jboss-media.xml
      boolean accepts = false;
      try
      {
         URL dd = di.localCl.findResource("META-INF/ejb-jar.xml");
         if (dd == null)
         {
            return false;
         }

         URL dm = di.localCl.findResource("META-INF/jboss-media.xml");
         if (dm == null)
         {
            return false;
         }

         // If the DD url is not a subset of the urlStr then this is coming
         // from a jar referenced by the deployment jar manifest and the
         // this deployment jar it should not be treated as an ejb-jar
         if (di.localUrl != null)
         {
            urlStr = di.localUrl.toString();
         }

         String ddStr = dd.toString();
         if (ddStr.indexOf(urlStr) >= 0)
         {
            accepts = true;
         }
      }
      catch (Exception ignore)
      {
      }

      return accepts;
   }

   /* (non-Javadoc)
    * @see org.jboss.deployment.SubDeployer#create(org.jboss.deployment.DeploymentInfo)
    */
   public synchronized void create(DeploymentInfo di)
      throws DeploymentException
   {
      super.create(di);

      try
      {
         // Spy: Have a look at this:
         /*MediaXmlLoader.deployXML(
            di.getW3CDocument(),
            di.localUrl,
            getServer());*/
      }
      catch (Exception e)
      {
         if (e instanceof DeploymentException)
            throw (DeploymentException) e;
         throw new DeploymentException("Failed to load metadata", e);
      }
   }

   /* (non-Javadoc)
    * @see org.jboss.deployment.SubDeployer#start(org.jboss.deployment.DeploymentInfo)
    */
   public synchronized void start(DeploymentInfo di) throws DeploymentException
   {
      // TODO Auto-generated method stub
      super.start(di);
   }

   protected void parseDocument(DeploymentInfo di) throws Exception
   {
      // Spy: Have a look at this:
      /*if (di.getDocument() == null)
      {
         //DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
         URL docURL = di.localUrl;
         // Load jboss-service.xml from the jar or directory
         if (di.isXML == false)
            docURL = di.localCl.findResource("META-INF/jboss-media.xml");
         // Validate that the descriptor was found
         if (docURL == null)
            throw new DeploymentException("Failed to find META-INF/jboss-media.xml");

         SAXReader sr = new SAXReader();
         di.setDocument(sr.read(docURL));
      }
      else
      {
         log.debug("Using existing deployment.document");
      }*/
   }

}