/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

/**
 * This exception is thrown during <code>MetaDataEntityLocalHome.query()</code>
 * whenever a specified query language is not supported
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class UnsupportedQueryLanguageException extends MediaException
{
   /**
    * @see javax.emb.MediaException()
    */
   public UnsupportedQueryLanguageException()
   {
      super();
   }

   /**
    * @see javax.emb.MediaException(String)
    */
   public UnsupportedQueryLanguageException(String message)
   {
      super(message);
   }

   /**
    * @see javax.emb.MediaException(String, Throwable)
    */
   public UnsupportedQueryLanguageException(String message, Throwable cause)
   {
      super(message, cause);
   }

   /**
    * @see javax.emb.MediaException(Throwable)
    */
   public UnsupportedQueryLanguageException(Throwable cause)
   {
      super(cause);
   }
}