/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

import javax.ejb.RemoveException;

/**
 * This exception is thrown if a media entity EJB cannot be removed because it
 * has parents that contain links pointing to the receiver. Removing a media
 * entity EJB while it has parents would violate referential integrity and is
 * therefore forbidden.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class ParentAssociationExistsException extends RemoveException
{
   /**
    * @see javax.ejb.RemoveException()
    */
   public ParentAssociationExistsException()
   {
      super();
   }

   /**
    * @see javax.ejb.RemoveException(String)
    */
   public ParentAssociationExistsException(String message)
   {
      super(message);
   }
}