/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

import java.io.Serializable;

/**
 * The interface MediaHeader defines the common behavior between media header
 * implementations. All media header instances must allow access to the format
 * specific header fields by name, in order to allow easy generic access in
 * case some information is required for browsing purposes. Additionally, all
 * header fields accessible by the <code>MediaHeader.getField(String)</code>
 * method must be accessible by standard getter methods, too. As media header
 * instances have to be transferred over machine boundaries at times, this
 * interface extends {@link java.io.Serializable}.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public interface MediaHeader extends Serializable
{
   /**
    * Returns an array of Strings containing all the field names defined for
    * the header.
    * 
    * @return an array of header field names.
    */
   String[] getFieldNames();

   /**
    * Returns the field with the given name downcast to
    * {@link java.lang.Object}. If the field is modeled as a Java base type,
    * an instance of the corresponding wrapper class has to be returned. The
    * value <code>null</code> is returned if a field name is passed that is
    * not defined for the receiver.
    * 
    * @param fieldName header field name.
    * @return the content of a header field.
    * @throws java.lang.NullPointerException if the value passed is <code>null</code>.
    */
   Object getField(String fieldName);
}