/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

/**
 * This exception is thrown if a location URL is not a valid URL, or if it does
 * not have a supported protocol type (like example "file").
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class MalformedLocationException extends MediaException
{
   /**
    * @see javax.emb.MediaException()
    */
   public MalformedLocationException()
   {
      super();
   }

   /**
    * @see javax.emb.MediaException(String)
    */
   public MalformedLocationException(String message)
   {
      super(message);
   }

   /**
    * @see javax.emb.MediaException(String, Throwable)
    */
   public MalformedLocationException(String message, Throwable cause)
   {
      super(message, cause);
   }

   /**
    * @see javax.emb.MediaException(Throwable)
    */
   public MalformedLocationException(Throwable cause)
   {
      super(cause);
   }
}