/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

/**
 * This exception is thrown during <code>MediaEntityLocal.setLocation(...)</code>
 * whenever the location can not be manually changed on the entity.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class LocationUnmutableException extends MediaException
{
   /**
    * @see javax.emb.MediaException()
    */
   public LocationUnmutableException()
   {
      super();
   }

   /**
    * @see javax.emb.MediaException(String)
    */
   public LocationUnmutableException(String message)
   {
      super(message);
   }

   /**
    * @see javax.emb.MediaException(String, Throwable)
    */
   public LocationUnmutableException(String message, Throwable cause)
   {
      super(message, cause);
   }

   /**
    * @see javax.emb.MediaException(Throwable)
    */
   public LocationUnmutableException(Throwable cause)
   {
      super(cause);
   }
}