/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

/**
 * This exception is thrown whenever a problem occurs translating a child link
 * contained in non-embedded media content into a location URL or vice versa,
 * for example because a relative filename is present when only absolute links
 * are allowed.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class LinkTranslationException extends MediaException
{
   /**
    * @see javax.emb.MediaException()
    */
   public LinkTranslationException()
   {
      super();
   }

   /**
    * @see javax.emb.MediaException(String)
    */
   public LinkTranslationException(String message)
   {
      super(message);
   }

   /**
    * @see javax.emb.MediaException(String, Throwable)
    */
   public LinkTranslationException(String message, Throwable cause)
   {
      super(message, cause);
   }

   /**
    * @see javax.emb.MediaException(Throwable)
    */
   public LinkTranslationException(Throwable cause)
   {
      super(cause);
   }
}