/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

/**
 * This class offers a generic implementation of the MediaHeader interface. It
 * is suitable for all kinds of media that don't expose any header information.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public final class GenericMediaHeader implements MediaHeader
{
   /**
    * Returns an empty array of Strings, as no header information is exposed.
    * 
    * @return an empty array of Strings.
    */
   public String[] getFieldNames()
   {
      return new String[0];
   }

   /**
    * Returns <code>null</code> regardless of the field name passed.
    * 
    * @param fieldName a header field name.
    * @return <code>null</code>
    * @throws java.lang.NullPointerException if the value passed is <code>null</code>.
    */
   public Object getField(String fieldname)
   {
      if (fieldname == null)
      {
         throw new NullPointerException();
      }

      return null;
   }
}